/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.periph.vecvoice;

import frc.emul.psg.IAudioSettings;
import frc.emul.psg.IExtraAudioLine;

public class SpeechLine
implements IExtraAudioLine {
    private volatile int pendingSamples;
    private volatile int itemsUsed;
    private volatile int itemIndex;
    private int sampleRateMult;
    private final SpeechItem[] items = new SpeechItem[3];
    private static final int READY_PAYLOAD = 3000;
    private static final int NB_ITEMS = 3;
    private static final byte FILL_BYTE = 0;

    public SpeechLine() {
        int n = 3;
        while (n-- > 0) {
            this.items[n] = new SpeechItem();
        }
    }

    public int getSampleRateMultiplier() {
        return this.sampleRateMult;
    }

    public boolean isEmpty() {
        return this.pendingSamples == 0;
    }

    public synchronized void clear() {
        this.pendingSamples = 0;
        this.itemsUsed = 0;
    }

    public synchronized boolean isReady() {
        return this.pendingSamples <= 3000 && this.itemsUsed < 3;
    }

    public synchronized void emit(int[] nArray, int n, int n2) {
        if (this.itemsUsed >= 3) {
            System.out.println("*** Speech line buffer full, discarding " + n2 + " samples.");
            return;
        }
        SpeechItem speechItem = this.items[(this.itemIndex + this.itemsUsed) % 3];
        ++this.itemsUsed;
        this.pendingSamples += n2;
        speechItem.data = nArray;
        speechItem.offset = n;
        speechItem.samples = n2;
    }

    public void updateSettings(IAudioSettings iAudioSettings) {
        this.sampleRateMult = iAudioSettings.getSampleRate() / 11025;
    }

    public synchronized void feed(int[] nArray, int n, int n2) {
        if (this.itemsUsed > 0) {
            SpeechItem speechItem = this.items[this.itemIndex];
            int n3 = speechItem.samples;
            if (n2 < n3) {
                System.arraycopy(speechItem.data, speechItem.offset, nArray, n, n2);
                this.pendingSamples -= n2;
                speechItem.offset += n2;
                speechItem.samples -= n2;
            } else {
                System.arraycopy(speechItem.data, speechItem.offset, nArray, n, n3);
                this.pendingSamples -= n3;
                this.itemIndex = (this.itemIndex + 1) % 3;
                --this.itemsUsed;
                this.feed(nArray, n + n3, n2 - n3);
            }
        } else {
            int n4 = n + n2;
            while (n < n4) {
                nArray[n++] = 0;
            }
        }
    }

    private class SpeechItem {
        int[] data;
        int offset;
        int samples;

        private SpeechItem() {
        }
    }
}

